/**********************************************************************************************
************************************************************************************************/
#include "User_Include.h"
//************************************************************************************************//
__interrupt void Ecap5_isr(void)
{
   ECap5Regs.ECCLR.bit.CEVT4 = 1;
   ECap5Regs.ECCLR.bit.INT = 1;
   ECap5Regs.ECCTL2.bit.REARM = 1;

   // Acknowledge this interrupt to receive more interrupts from group 4
   PieCtrlRegs.PIEACK.all = PIEACK_GROUP4;
}
//**********************************************************************
void main(void)
{
	int i =0 ;
// Initialize System Control:
// PLL, WatchDog, enable Peripheral Clocks
   InitSysCtrl();
// Initalize GPIO:
// This example function is found in the DSP2833x_Gpio.c file and
// illustrates how to set the GPIO to it's default state.
    InitGpio();
    DINT;
    InitPieCtrl();
// Disable CPU interrupts and clear all CPU interrupt flags:
    IER = 0x0000;
    IFR = 0x0000;
    InitPieVectTable();
    EALLOW;
	GpioCtrlRegs.GPBPUD.bit.GPIO48      = 0;  //
	GpioCtrlRegs.GPBMUX2.bit.GPIO48     = 1; // ecap
	GpioCtrlRegs.GPBQSEL2.bit.GPIO48 = 0; //
	EDIS;

    ECap5Regs.ECEINT.all = 0x0000; // Disable all capture interrupts
    ECap5Regs.ECCLR.all = 0xFFFF; // Clear all CAP interrupt flags
    ECap5Regs.ECCTL1.bit.PRESCALE = 0; //
    ECap5Regs.ECCTL1.bit.CAPLDEN = 0; // Disable CAP1-CAP4 register loads
    ECap5Regs.ECCTL2.bit.TSCTRSTOP = 0; // Make sure the counter is stopped
    // Configure peripheral registers
    ECap5Regs.ECCTL2.bit.CONT_ONESHT = 1; // continuous mode
    ECap5Regs.ECCTL2.bit.STOP_WRAP = 3; // Stop at 4 events
    ECap5Regs.ECCTL1.bit.CAP1POL = 0; // Rising edge
    ECap5Regs.ECCTL1.bit.CAP2POL = 0; // Rising edge
    ECap5Regs.ECCTL1.bit.CAP3POL = 0; // Rising edge
    ECap5Regs.ECCTL1.bit.CAP4POL = 0; // Rising edge
    ECap5Regs.ECCTL1.bit.CTRRST1 = 0; // Difference operation
    ECap5Regs.ECCTL1.bit.CTRRST2 = 0; // Difference operation
    ECap5Regs.ECCTL1.bit.CTRRST3 = 0; // Difference operation
    ECap5Regs.ECCTL1.bit.CTRRST4 = 0; // Difference operation
    ECap5Regs.ECCTL2.bit.SYNCI_EN = 0; // Enable sync in
    ECap5Regs.ECCTL2.bit.SYNCO_SEL = 2; // Pass through
    ECap5Regs.ECCTL1.bit.CAPLDEN = 1; // Enable capture units
    ECap5Regs.ECCTL2.bit.CAP_APWM =0;
    ECap5Regs.ECEINT.bit.CEVT4 = 1; // 4 events = interrupt

//    ECap5Regs.ECCTL2.bit.TSCTRSTOP = 1; // Start Counter
    //ECap5Regs.ECCTL2.bit.REARM = 1; // arm one-shot
    InitPieVectTable();
    EALLOW;
    PieVectTable.ECAP5_INT = &Ecap5_isr;
    EDIS;
    PieCtrlRegs.PIEIER4.bit.INTx5 = 1;
      IER |= M_INT4 ;
    EALLOW;
    SysCtrlRegs.PCLKCR1.bit.ECAP5ENCLK=1;
    EDIS;
    EINT;
    ERTM;
   ECap5Regs.ECCTL2.bit.TSCTRSTOP = 1;        // Start Counter
   for(;;)
   {
	   i++;
   }
}

//*****************************    *********************************************
//*****************************      END     *****************************************
